.H 1 "Journal Window"
This window, if opened, keeps a log of the following events for a process:
.AL 1
.LI
A copy of the status line and the line for the most recent activation
record in the Process window, every time they are updated.
.LI
The selection of any menu operators that cause that process to execute,
step, or stop.
.LI
Every time a conditional breakpoint or tracepoint is hit,
a copy of the updated source statement from the Source Text window.
.LI
Any spy expressions that change values.
.LE
.P
The window does not generate menus or accept keyboard input, and cannot
be opened for core dumps.
.H 2 "Journal Layout"
The title bar lists the process id number and the window
displays logged information.
For example, part of a typical log is shown below:
.DS I N
run
RUNNING:  pc=test1.c:21
test1.c:21 [5] i=3, j=16, i==5=0 a()   j += b(i);
test1.c:21 [6] i=4, j=22, i==5=0 a()   j += b(i);
test1.c:21 [7] i=5, j=29, i==5=1 a()   j += b(i);
BREAKPOINT:
test1.c:21 a(i=5,j=29)
.DE
.P
The "run" line was  inserted into the window by selecting
"run" in the "stmt" menu.
The "RUNNING" line is a copy of the updated status line in the Process window.
The next three lines are hits to the conditional breakpoint
"i, j, i==5" on line 21 in the file test1.c.
When the value of i was 5 the breakpoint condition was true,
causing the process to stop.
The last two lines are copies of the updated status line and
top activation record in the Process window.
.P
If a line entered into the Journal window is identical to the previous line,
rather than repeating the same line multiple times a count in parenthesis is
appended to the previous line to indicate it occurs again.
This is likely when the process is blocked in a system call,
such as read, causing the same status line from the Process
window to be inserted into the Journal window once a second until
the call returns.
.P
The Journal window is most useful when used with conditional
breakpoints to trace the values of C variables or expressions.
For example, to keep a record of the values of
the arguments passed to a function each time it is called:
.AL 1
.LI
Display the function in the Source Text window.
.LI
Select the statement where you want to evaluate the arguments.
.LI
In the statement's line menu, select the "cond bpt" entry and for each argument
you want to trace, type in its name followed by a comma,
and end the line with a 0. 
For example, to trace arguments arg1 and arg2 enter:
.DS I N
arg1, arg2, 0
.DE
.P
This conditional breakpoint displays the values of arg1 and arg2
each time it is hit, but never stops the process.
.LI
Open the Journal window from the "Journal" entry in the
Process window's "views" menu.
.LI
Start the process executing with "run" in the "stmt" menu.
.LE
.P
Every time the function is entered, the conditional breakpoint will be
hit and evaluated, causing the values of the arguments to be entered into
the Journal window.
Since the format used to display the values of variables in condition
breakpoints is inherited from their Frame window settings, you may use a
Frame window to control how traced variables are displayed in the Journal.
.P
The Journal window is currently limited to 200 lines.
When the window reaches its maximum length, new lines added to the window
delete the lines at the beginning. 
